//
// Fragment shader for depth of field effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform sampler2DRect blurTexUnit;
uniform vec4 textureRect;
uniform float centerX;
uniform float centerY;
uniform float blurRadius;
uniform float sharpRadius;
uniform  vec4 modulateColor;
uniform vec2 drawingOffset;
uniform vec2 drawingScale;

varying vec2 gUV;
const vec3 lumCoeff = vec3(0.2125, 0.7154, 0.0721);
void main ()
{
   if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        vec3 intensity;
        vec4 outputColor;
        // This pixel location
        vec3 pCoord = gl_FragCoord.xyz;
         // Transform back to render traget coord space
        pCoord /= vec3(drawingScale, 1);
        pCoord += vec3(drawingOffset, 0);

        // Calculate the distance from this pixel to the center
        float distance =sqrt(pow(pCoord.x-centerX, 2.0) +pow(pCoord.y-centerY,2.0));
        
        // final image is blending between sharp and blur image
        vec4 sharpColor = texture2DRect(texUnit, gUV);
        vec4 blurColor = texture2DRect(blurTexUnit, gUV);
        
        float a  = blurRadius > sharpRadius? 1.0/(blurRadius-sharpRadius):0.0;
        float lerp = distance < sharpRadius? 0.0:a*distance-a*sharpRadius ;
        lerp = clamp(lerp, 0.0, 1.0);
        
        intensity = vec3(dot(sharpColor.rgb, lumCoeff));
        sharpColor.rgb = mix(intensity, sharpColor.rgb, 1.25);
        outputColor = sharpColor*(1.0-lerp) + lerp*blurColor;
       /*
        if ( distance < sharpRadius)
            gl_FragColor = vec4(0,0,1,1); 
        else 
            gl_FragColor = blurColor; 
    */
        gl_FragColor = modulateColor * outputColor;
        gl_FragColor.a = texture2DRect(texUnit, gUV).a;
    }
}

